/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.compras;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.ObjetoModeloSucesorValidableAnotado;
import ec.gob.sri.dimm.api.modelo.persistencia.Exportable;
import ec.gob.sri.dimm.api.modelo.persistencia.Importable;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionEditable;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.data.impl.UtilCatalogosATS;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FormaPago
extends ObjetoModeloSucesorValidableAnotado<ObjetoModelo>
implements InformacionEditable<FormaPago>,
Exportable,
Importable {
    private static final long serialVersionUID = 2574835977213376845L;
    public static final String C_TIPO_FORMA_PAGO = "tipoFormaPago";
    public static final String C_SUMATORIA_BASES_IMPONIBLES = "sumatoriaBasesImponibles";
    @NotNull(message="Debe seleccionar el tipo de Forma de Pago")
    private String tipoFormaPago;
    private String descripcionTipoFormaPago;
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="El valor Sumatoria de Bases Imponibles debe ser 12 enteros y 2 decimales. ")
    private String sumatoriaBasesImponibles;

    protected ResultadoValidacion validarObjeto() {
        return null;
    }

    public FormaPago crearCopiaEdicion() {
        FormaPago copia = new FormaPago();
        copia.setTipoFormaPago(this.tipoFormaPago);
        copia.setDescripcionTipoFormaPago(this.descripcionTipoFormaPago);
        copia.setSumatoriaBasesImponibles(this.sumatoriaBasesImponibles);
        copia.setPropietario(this.propietario);
        return copia;
    }

    public void actualizarInformacion(FormaPago copiaEdicion) {
        this.setTipoFormaPago(copiaEdicion.getTipoFormaPago());
        this.setDescripcionTipoFormaPago(copiaEdicion.getDescripcionTipoFormaPago());
        this.setSumatoriaBasesImponibles(copiaEdicion.getSumatoriaBasesImponibles());
    }

    public Object importar(Element elemento, Map<String, Element> mapaData) {
        this.tipoFormaPago = elemento.getTextContent().trim();
        this.descripcionTipoFormaPago = UtilCatalogosATS.obtenerNombreDetalleCatalogo((String)"FORMPAGO", (String)this.getTipoFormaPago());
        return this;
    }

    public String getTipoFormaPago() {
        return this.tipoFormaPago;
    }

    public String getDescripcionTipoFormaPago() {
        return this.descripcionTipoFormaPago;
    }

    public String getSumatoriaBasesImponibles() {
        return this.sumatoriaBasesImponibles;
    }

    public void setTipoFormaPago(String tipoFormaPago) {
        String oldValue = this.tipoFormaPago;
        this.tipoFormaPago = StringUtil.isNullOrEmpty((String)tipoFormaPago) ? tipoFormaPago : tipoFormaPago.toUpperCase();
        this.firePropertyChange(C_TIPO_FORMA_PAGO, oldValue, this.tipoFormaPago);
    }

    public void setDescripcionTipoFormaPago(String descripcionTipoFormaPago) {
        this.descripcionTipoFormaPago = descripcionTipoFormaPago;
    }

    public void setSumatoriaBasesImponibles(String sumatoriaBasesImponibles) {
        String oldValue = this.sumatoriaBasesImponibles;
        this.sumatoriaBasesImponibles = sumatoriaBasesImponibles;
        this.firePropertyChange(C_SUMATORIA_BASES_IMPONIBLES, oldValue, this.sumatoriaBasesImponibles);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.tipoFormaPago == null ? 0 : this.tipoFormaPago.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        FormaPago other = (FormaPago)((Object)obj);
        return !(this.tipoFormaPago == null ? other.tipoFormaPago != null : !this.tipoFormaPago.equals(other.tipoFormaPago));
    }

    public Element exportar(Document documento, Element elemento) {
        Element em = documento.createElement("formaPago");
        em.setTextContent(this.getTipoFormaPago());
        return em;
    }
}

